/*
 * @(#)OMDependency.java  1.0  4. Februar 2004
 *
 * Copyright (c) 2003 Lucerne University of Applied Sciences and Arts (HSLU)
 * Zentralstrasse 18, Postfach 2858, CH-6002 Lucerne, Switzerland
 * All rights reserved.
 *
 * The copyright of this software is owned by the Lucerne University of Applied 
 * Sciences and Arts (HSLU). You may not use, copy or modify this software, 
 * except in accordance with the license agreement you entered into with HSLU. 
 * For details see accompanying license terms. 
 */

package ch.hslu.cm.oo.objectmodel;

import java.beans.*;
import ch.hslu.cm.simulation.*;
/**
 * Simulates the structure and behavior of a dependency between two classes.
 * 
 * 
 * @author Werner Randelshofer
 * @version 1.0 4. Februar 2004  Created.
 */
public class OMDependency extends AbstractRelationship {
    private PropertyChangeSupport changeSupport;
    
    /** Creates a new instance. */
    public OMDependency() {
        changeSupport = new PropertyChangeSupport(this);
    }
    
    public void addPropertyChangeListener(PropertyChangeListener l) {
        changeSupport.addPropertyChangeListener(l);
    }
    public void removePropertyChangeListener(PropertyChangeListener l) {
        changeSupport.removePropertyChangeListener(l);
    }
    
    public int getSimulatedConcept() {
        return ObjectModel.DEPENDENCY;
    }
    
    public OMDependency clone() {
        OMDependency that = (OMDependency) super.clone();
        that.changeSupport = new PropertyChangeSupport(that);
        return that;
    }
    
    public boolean canConnect(SimulatedElement start, SimulatedElement end) {
        
        if (
        (start.getSimulatedConcept() == ObjectModel.CLASS
        || start.getSimulatedConcept() == ObjectModel.OBJECT)
        && (end.getSimulatedConcept() == ObjectModel.CLASS
        || end.getSimulatedConcept() == ObjectModel.OBJECT)
        && start != end) {
            return true;
        }
        return false;
    }
    
    public boolean canConnect(SimulatedElement start) {
        int concept = start.getSimulatedConcept();
        return concept == ObjectModel.CLASS || concept == ObjectModel.OBJECT;
    }
}
